package org.eclipse.jem.tests.beaninfo.javax.swing;
/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.beans.*;

import org.eclipse.jem.tests.beaninfo.preq.infos.BaseBeanInfo;
public class JComponentBeanInfo extends BaseBeanInfo {
	
/**
 * Gets the componentevent set descriptor.
 * @return java.beans.EventSetDescriptor
 */
public EventSetDescriptor ancestorEventSetDescriptor() {
	EventSetDescriptor aDescriptor = null;
	Class[] paramTypes = { javax.swing.event.AncestorEvent.class };
	MethodDescriptor aDescriptorList[] = {
			super.createMethodDescriptor(javax.swing.event.AncestorListener.class,
				"ancestorAdded", 
				new Object[] {
	   			DISPLAYNAME, "ancestorAdded",
	      		SHORTDESCRIPTION, "Event fired when an ancestor is added to component hierarchy",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("ancestorEvent", new Object[] {
	   				DISPLAYNAME, "ancestorEvent",
	      			// SHORTDESCRIPTION, "ancestor added event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	),
		  	super.createMethodDescriptor(javax.swing.event.AncestorListener.class,
				"ancestorMoved", 
				new Object[] {
	   			DISPLAYNAME, "ancestorMoved",
	      		SHORTDESCRIPTION, "Event fired when an ancestor is moved",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("ancestorEvent", new Object[] {
	   				DISPLAYNAME, "ancestorEvent",
	      			// SHORTDESCRIPTION, "ancestor moved event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	),
		  	super.createMethodDescriptor(javax.swing.event.AncestorListener.class,
				"ancestorRemoved", 
				new Object[] {
	   			DISPLAYNAME, "ancestorRemoved",
	      		SHORTDESCRIPTION, "Event fired when an ancestor is removed",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("ancestorEvent", new Object[] {
	   				DISPLAYNAME, "ancestorEvent",
	      			// SHORTDESCRIPTION, "ancestor removed event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	)
		};	
		aDescriptor = super.createEventSetDescriptor(getBeanClass(),
						"ancestor", new Object[] {
						DISPLAYNAME, "ancestorEvents",
	      				SHORTDESCRIPTION, "All ancestor events",
	      			}, 
						aDescriptorList, javax.swing.event.AncestorListener.class,
						"addAncestorListener", "removeAncestorListener");

	return aDescriptor;
}
/**
 * Gets the bean class.
 * @return java.lang.Class
 */
public Class getBeanClass() {
	return javax.swing.JComponent.class;
}
public java.beans.BeanDescriptor getBeanDescriptor() {
	java.beans.BeanDescriptor aDescriptor = null;
	/* Create and return the bean descriptor. */
	try {
		aDescriptor = createBeanDescriptor(getBeanClass(), new Object[] {
	               		DISPLAYNAME, "JComponent",
	        			SHORTDESCRIPTION, "Base class for JFC components"
						}			    
				  	  );
		aDescriptor.setValue("ICON_COLOR_32x32", "icons/jcomponentcolor32.gif");
		aDescriptor.setValue("ICON_COLOR_16x16", "icons/jcomponentcolor16.gif");
	} catch (Throwable exception) {
		handleException(exception);
	};
	return aDescriptor;
}
/**
 * Return the event set descriptors for this bean.
 * @return java.beans.EventSetDescriptor[]
 */
public java.beans.EventSetDescriptor[] getEventSetDescriptors() {
	try {
		EventSetDescriptor aDescriptorList[] = {
			ancestorEventSetDescriptor(),
			propertyChangeEventSetDescriptor(),
			vetoableChangeEventSetDescriptor()
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
	/**
	 * @return an icon of the specified kind for JButton
	 */
	public java.awt.Image getIcon(int kind) {
	if (kind == ICON_COLOR_32x32) 
	    return loadImage("jcomponentcolor32.gif");
	if (kind == ICON_COLOR_16x16) 
	    return loadImage("jcomponentcolor16.gif");
   return super.getIcon(kind);
	}
/**
 * Return the method descriptors for this bean.
 * @return java.beans.MethodDescriptor[]
 */
public java.beans.MethodDescriptor[] getMethodDescriptors() {
	try {
		MethodDescriptor aDescriptorList[] = {
			// addNotify()
			super.createMethodDescriptor(getBeanClass(),"addNotify", 
				new Object[] {
	   			DISPLAYNAME, "addNotify()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Notify component that it has a parent",
	    		}, 
	    		new ParameterDescriptor[] {},
	      	new Class[] {}		    		
		  	),
		  	// computeVisibleRect(Rectangle)
		  	super.createMethodDescriptor(getBeanClass(),"computeVisibleRect", 
				new Object[] {
	   			DISPLAYNAME, "computeVisibleRect(Rectangle)",
	      		// SHORTDESCRIPTION, "Compute the visible rectangle for the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("visibleRect", new Object[] {
	   				DISPLAYNAME, "visibleRect",
	      			// SHORTDESCRIPTION, "rectangle",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Rectangle.class 
	      		}	    		
		  	),
		  	// contains(int,int)
			super.createMethodDescriptor(getBeanClass(), "contains", 
				new Object[] {
	   				DISPLAYNAME, "contains(int,int)",
	      			SHORTDESCRIPTION, "Check if the component contains point",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("x", new Object[] {
	   					DISPLAYNAME, "x",
	      				// SHORTDESCRIPTION, "x coordinate of point",
	      			}),
	      			createParameterDescriptor("y", new Object[] {
	   					DISPLAYNAME, "y",
	      				// SHORTDESCRIPTION, "y coordinate of point",
	      			})		
	      		},
	      		new Class[] { 
	      			int.class,
	      			int.class
	      		}   		
		  	),
		  	// createToolTip()
			super.createMethodDescriptor(getBeanClass(),"createToolTip", 
				new Object[] {
	   				DISPLAYNAME, "createToolTip()",
	      			// SHORTDESCRIPTION, "Create tooltip instance",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// firePropertyChange(String,boolean,boolean)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,boolean,boolean)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			boolean.class, boolean.class
	      		}   		
		  	),
		  	// firePropertyChange(String,char,char)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,char,char)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			char.class, char.class
	      		}   		
		  	),
		  	// firePropertyChange(String,double,double)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,double,double)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			double.class, double.class
	      		}   		
		  	),
		  	// firePropertyChange(String,float,float)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,float,float)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			float.class, float.class
	      		}   		
		  	),
		  	// firePropertyChange(String,int,int)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,int,int)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			int.class, int.class
	      		}   		
		  	),
		  	// firePropertyChange(String,long,long)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,long,long)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			long.class, long.class
	      		}   		
		  	),
		  	// firePropertyChange(String,short,short)
			super.createMethodDescriptor(getBeanClass(), "firePropertyChange", 
				new Object[] {
	   				DISPLAYNAME, "firePropertyChange(String,short,short)",
	      			// SHORTDESCRIPTION, "Notify property change",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyName", new Object[] {
	   					DISPLAYNAME, "propertyName",
	      				// SHORTDESCRIPTION, "Name of changed property",
	      			}),
	      			createParameterDescriptor("oldValue", new Object[] {
	   					DISPLAYNAME, "oldValue",
	      				// SHORTDESCRIPTION, "old value",
	      			}),
	      			createParameterDescriptor("newValue", new Object[] {
	   					DISPLAYNAME, "newValue",
	      				// SHORTDESCRIPTION, "new value"
	      			})		
	      		},
	      		new Class[] { 
	      			java.lang.String.class,
	      			short.class, short.class
	      		}   		
		  	),
		  	// getAccessibleContext()
			super.createMethodDescriptor(getBeanClass(),"getAccessibleContext", 
				new Object[] {
	   				DISPLAYNAME, "getAccessibleContext()",
	      			// SHORTDESCRIPTION, "Get the accessible context",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getActionForKeyStroke(KeyStroke)
		  	super.createMethodDescriptor(getBeanClass(),"getActionForKeyStroke", 
				new Object[] {
	   			DISPLAYNAME, "getActionForKeyStroke(KeyStroke)",
	      		// SHORTDESCRIPTION, "Get the action listener object invoked for keystroke",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aKeyStroke", new Object[] {
	   				DISPLAYNAME, "aKeyStroke",
	      			// SHORTDESCRIPTION, "key stroke",
	      			})
	      		},
	      		new Class[] { 
	      			javax.swing.KeyStroke.class 
	      		}	    		
		  	),
		  	// getAlignmentX()
			super.createMethodDescriptor(getBeanClass(),"getAlignmentX", 
				new Object[] {
	   				DISPLAYNAME, "getAlignmentX()",
	      			// SHORTDESCRIPTION, "Get the X alignment",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getAlignmentY()
			super.createMethodDescriptor(getBeanClass(),"getAlignmentY", 
				new Object[] {
	   				DISPLAYNAME, "getAlignmentY()",
	      			// SHORTDESCRIPTION, "Get the Y alignment",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getAutoscrolls()
			super.createMethodDescriptor(getBeanClass(),"getAutoscrolls", 
				new Object[] {
	   				DISPLAYNAME, "getAutoscrolls()",
	      			SHORTDESCRIPTION, "TRUE if component auto scrolls",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getBorder()
			super.createMethodDescriptor(getBeanClass(),"getBorder", 
				new Object[] {
	   				DISPLAYNAME, "getBorder()",
	      			// SHORTDESCRIPTION, "Get the Border object",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getBounds(Rectangle)
		  	super.createMethodDescriptor(getBeanClass(),"getBounds", 
				new Object[] {
	   			DISPLAYNAME, "getBounds(Rectangle)",
	      		SHORTDESCRIPTION, "Get the bounding rectangle",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("rv", new Object[] {
	   				DISPLAYNAME, "aRectangle",
	      			// SHORTDESCRIPTION, "Rectangle holds return values",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Rectangle.class 
	      		}	    		
		  	),
		  	// getClientProperty(Object)
		  	super.createMethodDescriptor(getBeanClass(),"getClientProperty", 
				new Object[] {
	   			DISPLAYNAME, "getClientProperty(Object)",
	      		// SHORTDESCRIPTION, "Get the property value for key",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("key", new Object[] {
	   				DISPLAYNAME, "aKey",
	      			// SHORTDESCRIPTION, "key for look up",
	      			})
	      		},
	      		new Class[] { 
	      			java.lang.Object.class 
	      		}	    		
		  	),
		  	// getConditionForKeyStroke(KeyStroke)
		  	super.createMethodDescriptor(getBeanClass(),"getConditionForKeyStroke", 
				new Object[] {
	   			DISPLAYNAME, "getConditionForKeyStroke(KeyStroke)",
	      		// SHORTDESCRIPTION, "Get the condition for invoking the keystroke",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aKeyStroke", new Object[] {
	   				DISPLAYNAME, "aKeyStroke",
	      			// SHORTDESCRIPTION, "key stroke",
	      			})
	      		},
	      		new Class[] { 
	      			javax.swing.KeyStroke.class 
	      		}	    		
		  	),
		  	// getGraphics()
		  	super.createMethodDescriptor(getBeanClass(),"getGraphics", 
				new Object[] {
	   				DISPLAYNAME, "getGraphics()",
	      			// SHORTDESCRIPTION, "Get the component's graphics context"
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getHeight()
		  	super.createMethodDescriptor(getBeanClass(),"getHeight", 
				new Object[] {
	   				DISPLAYNAME, "getHeight()",
	      			// SHORTDESCRIPTION, "Get the component's height",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getInsets()
		  	super.createMethodDescriptor(getBeanClass(),"getInsets", 
				new Object[] {
	   				DISPLAYNAME, "getInsets()",
	      			// SHORTDESCRIPTION, "Get the component border's insets",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getLocation(Point)
		  	super.createMethodDescriptor(getBeanClass(),"getLocation", 
				new Object[] {
	   			DISPLAYNAME, "getLocation(Point)",
	      		// SHORTDESCRIPTION, "Get the component's origin",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("rv", new Object[] {
	   				DISPLAYNAME, "aPoint",
	      			// SHORTDESCRIPTION, "Point contains origin",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Point.class 
	      		}	    		
		  	),
		  	// getMaximumSize()
		  	super.createMethodDescriptor(getBeanClass(),"getMaximumSize", 
				new Object[] {
	   				DISPLAYNAME, "getMaximumSize()",
	      			// SHORTDESCRIPTION, "Get the maximum size of the component",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getMinimumSize()
		  	super.createMethodDescriptor(getBeanClass(),"getMinimumSize", 
				new Object[] {
	   				DISPLAYNAME, "getMinimumSize()",
	      			// SHORTDESCRIPTION, "Get the minimum size of the component",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getNextFocusableComponent()
		  	super.createMethodDescriptor(getBeanClass(),"getNextFocusableComponent", 
				new Object[] {
	   				DISPLAYNAME, "getNextFocusableComponent()",
	      			SHORTDESCRIPTION, "Get the next component to get focus",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getPreferredSize()
		  	super.createMethodDescriptor(getBeanClass(),"getPreferredSize", 
				new Object[] {
	   				DISPLAYNAME, "getPreferredSize()",
	      			// SHORTDESCRIPTION, "Get the preferred size of the component",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getRegisteredKeyStrokes()
		  	super.createMethodDescriptor(getBeanClass(),"getRegisteredKeyStrokes", 
				new Object[] {
	   				DISPLAYNAME, "getRegisteredKeyStrokes()",
	      			// SHORTDESCRIPTION, "Get an array of KeyStroke objects",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getRootPane()
		  	super.createMethodDescriptor(getBeanClass(),"getRootPane", 
				new Object[] {
	   				DISPLAYNAME, "getRootPane()",
	      			// SHORTDESCRIPTION, "Get the component root pane",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getSize(Dimension)
		  	super.createMethodDescriptor(getBeanClass(),"getSize", 
				new Object[] {
	   			DISPLAYNAME, "getSize(Dimension)",
	      		// SHORTDESCRIPTION, "Get the component's dimensions",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("rv", new Object[] {
	   				DISPLAYNAME, "aDimension",
	      			// SHORTDESCRIPTION, "Dimension contains dimensions",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Dimension.class 
	      		}	    		
		  	),
		  	// getToolTipText()
		  	super.createMethodDescriptor(getBeanClass(),"getToolTipText", 
				new Object[] {
	   				DISPLAYNAME, "getToolTipText()",
	      			// SHORTDESCRIPTION, "Get the tool tip text for component",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getTopLevelAncestor()
		  	super.createMethodDescriptor(getBeanClass(),"getTopLevelAncestor", 
				new Object[] {
	   				DISPLAYNAME, "getTopLevelAncestor()",
	      			// SHORTDESCRIPTION, "Get the top-level container",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getVisibleRect()
		  	super.createMethodDescriptor(getBeanClass(),"getVisibleRect", 
				new Object[] {
	   				DISPLAYNAME, "getVisibleRect()",
	      			// SHORTDESCRIPTION, "Get the component's visible rectangle",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getWidth()
		  	super.createMethodDescriptor(getBeanClass(),"getWidth", 
				new Object[] {
	   				DISPLAYNAME, "getWidth()",
	      			// SHORTDESCRIPTION, "Get the component's width",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getX()
		  	super.createMethodDescriptor(getBeanClass(),"getX", 
				new Object[] {
	   				DISPLAYNAME, "getX()",
	      			// SHORTDESCRIPTION, "Get the component's x location",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// getY()
		  	super.createMethodDescriptor(getBeanClass(),"getY", 
				new Object[] {
	   				DISPLAYNAME, "getY()",
	      			// SHORTDESCRIPTION, "Get the component's y location",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// grabFocus()
		  	super.createMethodDescriptor(getBeanClass(),"grabFocus", 
				new Object[] {
	   				DISPLAYNAME, "grabFocus()",
	      			// SHORTDESCRIPTION, "Set the focus on the component",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// hasFocus()
		  	super.createMethodDescriptor(getBeanClass(),"hasFocus", 
				new Object[] {
	   				DISPLAYNAME, "hasFocus()",
	      			SHORTDESCRIPTION, "TRUE if component has keyboard focus",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isDoubleBuffered()
		  	super.createMethodDescriptor(getBeanClass(),"isDoubleBuffered", 
				new Object[] {
	   				DISPLAYNAME, "isDoubleBuffered()",
	      			SHORTDESCRIPTION, "TRUE if component painting is buffered",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isFocusCycleRoot()
		  	super.createMethodDescriptor(getBeanClass(),"isFocusCycleRoot", 
				new Object[] {
	   				DISPLAYNAME, "isFocusCycleRoot()",
	      			// SHORTDESCRIPTION, "TRUE if component subtree has focus cycle",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isFocusTraversable()
		  	super.createMethodDescriptor(getBeanClass(),"isFocusTraversable", 
				new Object[] {
	   				DISPLAYNAME, "isFocusTraversable()",
	      			SHORTDESCRIPTION, "TRUE if component can receive focus",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isManagingFocus()
		  	super.createMethodDescriptor(getBeanClass(),"isManagingFocus", 
				new Object[] {
	   				DISPLAYNAME, "isManagingFocus()",
	      			// SHORTDESCRIPTION, "TRUE if component manages focus",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isOpaque()
		  	super.createMethodDescriptor(getBeanClass(),"isOpaque", 
				new Object[] {
	   				DISPLAYNAME, "isOpaque()",
	      			SHORTDESCRIPTION, "TRUE if the component is completely opaque",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isOptimizedDrawingEnabled()
		  	super.createMethodDescriptor(getBeanClass(),"isOptimizedDrawingEnabled", 
				new Object[] {
	   				DISPLAYNAME, "isOptimizedDrawingEnabled()",
	      			// SHORTDESCRIPTION, "TRUE if the component tiles its children",
	      			EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isRequestFocusEnabled()
		  	super.createMethodDescriptor(getBeanClass(),"isRequestFocusEnabled", 
				new Object[] {
	   				DISPLAYNAME, "isRequestFocusEnabled()",
	      			SHORTDESCRIPTION, "TRUE if component can get focus by calling requestFocus",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// isValidateRoot()
		  	super.createMethodDescriptor(getBeanClass(),"isValidateRoot", 
				new Object[] {
	   				DISPLAYNAME, "isValidateRoot()",
	      			SHORTDESCRIPTION, "TRUE if entire component subtree is always validated",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}	    		
		  	),
		  	// paint(Graphics)
		  	super.createMethodDescriptor(getBeanClass(),"paint", 
				new Object[] {
	   			DISPLAYNAME, "paint(Graphics)",
	      		// SHORTDESCRIPTION, "Paint the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("g", new Object[] {
	   				DISPLAYNAME, "graphics",
	      			// SHORTDESCRIPTION, "Graphics Context for painting",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Graphics.class 
	      		}	    		
		  	),
		  	// paintImmediately(Rectangle)
		  	super.createMethodDescriptor(getBeanClass(),"paintImmediately", 
				new Object[] {
	   			DISPLAYNAME, "paintImmediately(Rectangle)",
	      		// SHORTDESCRIPTION, "Paint the component region",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("r", new Object[] {
	   				DISPLAYNAME, "rectangle",
	      			// SHORTDESCRIPTION, "Painting region",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Rectangle.class 
	      		}	    		
		  	),
		  	// putClientProperty(Object,Object)
		  	super.createMethodDescriptor(getBeanClass(),"putClientProperty", 
				new Object[] {
	   			DISPLAYNAME, "putClientProperty(Object,Object)",
	      		// SHORTDESCRIPTION, "Store a property value",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("key", new Object[] {
	   				DISPLAYNAME, "key",
	      			// SHORTDESCRIPTION, "key",
	      			}),
	    			createParameterDescriptor("value", new Object[] {
	   				DISPLAYNAME, "value",
	      			// SHORTDESCRIPTION, "Property value",
	      			})
	      		},
	      		new Class[] { 
	      			java.lang.Object.class, java.lang.Object.class
	      		}	    		
		  	),
			// removeNotify()
			super.createMethodDescriptor(getBeanClass(),"removeNotify", 
				new Object[] {
	   			DISPLAYNAME, "removeNotify()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Notify component that it has no parent",
	    		}, 
	    		new ParameterDescriptor[] {},
	      	new Class[] {}		    		
		  	),
		  	// repaint(Rectangle)
		  	super.createMethodDescriptor(getBeanClass(),"repaint", 
				new Object[] {
	   			DISPLAYNAME, "repaint(Rectangle)",
	      		// SHORTDESCRIPTION, "Repaint the rectangular region",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("r", new Object[] {
	   				DISPLAYNAME, "rectangle",
	      			// SHORTDESCRIPTION, "Painting region",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Rectangle.class 
	      		}	    		
		  	),
		  	// requestDefaultFocus()
			super.createMethodDescriptor(getBeanClass(),"requestDefaultFocus", 
				new Object[] {
	   			DISPLAYNAME, "requestDefaultFocus()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Request focus for component with default focus",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// requestFocus()
			super.createMethodDescriptor(getBeanClass(),"requestFocus", 
				new Object[] {
	   			DISPLAYNAME, "requestFocus()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Set focus on component",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// resetKeyboardActions()
			super.createMethodDescriptor(getBeanClass(),"resetKeyboardActions", 
				new Object[] {
	   			DISPLAYNAME, "resetKeyboardActions()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Unregister all keyboard actions",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// revalidate()
			super.createMethodDescriptor(getBeanClass(),"revalidate", 
				new Object[] {
	   			DISPLAYNAME, "revalidate()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Validate the component",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// scrollRectToVisible(Rectangle)
		  	super.createMethodDescriptor(getBeanClass(),"scrollRectToVisible", 
				new Object[] {
	   			DISPLAYNAME, "scrollRectToVisible(Rectangle)",
	      		// SHORTDESCRIPTION, "Scroll the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aRect", new Object[] {
	   				DISPLAYNAME, "rectangle",
	      			// SHORTDESCRIPTION, "Region to scroll to",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Rectangle.class 
	      		}	    		
		  	),
		  	// setAlignmentX(float)
		  	super.createMethodDescriptor(getBeanClass(),"setAlignmentX", 
				new Object[] {
	   			DISPLAYNAME, "setAlignmentX(float)",
	      		SHORTDESCRIPTION, "Preferred horizontal alignment for component",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("alignmentX", new Object[] {
	   				DISPLAYNAME, "alignmentX",
	      			// SHORTDESCRIPTION, "Float value between 0 and 1",
	      			})
	      		},
	      		new Class[] { 
	      			float.class 
	      		}	    		
		  	),
		  	// setAlignmentY(float)
		  	super.createMethodDescriptor(getBeanClass(),"setAlignmentY", 
				new Object[] {
	   			DISPLAYNAME, "setAlignmentY(float)",
	      		SHORTDESCRIPTION, "Preferred vertical alignment for component",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("alignmentY", new Object[] {
	   				DISPLAYNAME, "alignmentY",
	      			// SHORTDESCRIPTION, "Float value between 0 and 1",
	      			})
	      		},
	      		new Class[] { 
	      			float.class 
	      		}	    		
		  	),
		  	// setAutoscrolls(boolean)
		  	super.createMethodDescriptor(getBeanClass(),"setAutoscrolls", 
				new Object[] {
	   			DISPLAYNAME, "setAutoscrolls(boolean)",
	      		// SHORTDESCRIPTION, "Whether the component auto scrolls in a viewport",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("autoscrolls", new Object[] {
	   				DISPLAYNAME, "autoscrolls",
	      			// SHORTDESCRIPTION, "TRUE if the component auto scrolls",
	      			})
	      		},
	      		new Class[] { 
	      			boolean.class 
	      		}	    		
		  	),
		  	// setBorder(Border)
		  	super.createMethodDescriptor(getBeanClass(),"setBorder", 
				new Object[] {
	   			DISPLAYNAME, "setBorder(Border)",
	      		// SHORTDESCRIPTION, "Set the component's border",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("border", new Object[] {
	   				DISPLAYNAME, "border",
	      			// SHORTDESCRIPTION, "Border object",
	      			})
	      		},
	      		new Class[] { 
	      			javax.swing.border.Border.class 
	      		}	    		
		  	),
		  	// setBounds(Rectangle)
		  	super.createMethodDescriptor(getBeanClass(),"setBounds", 
				new Object[] {
	   			DISPLAYNAME, "setBounds(Rectangle)",
	      		// SHORTDESCRIPTION, "Move and resize the component",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("r", new Object[] {
	   				DISPLAYNAME, "rectangle",
	      			// SHORTDESCRIPTION, "Bounding rectangle",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Rectangle.class
	      		}	    		
		  	),
		  	// setDebugGraphicsOptions(int)
		  	super.createMethodDescriptor(getBeanClass(),"setDebugGraphicsOptions", 
				new Object[] {
	   			DISPLAYNAME, "setDebugGraphicsOptions(int)",
	      		// SHORTDESCRIPTION, "Diagnostic options for graphics operations",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("debugOptions", new Object[] {
	   				DISPLAYNAME, "debugOptions",
	      			// SHORTDESCRIPTION, "Value for options ",
	      			})
	      		},
	      		new Class[] { 
	      			int.class
	      		}	    		
		  	),
		  	// setDoubleBuffered(boolean)
		  	super.createMethodDescriptor(getBeanClass(),"setDoubleBuffered", 
				new Object[] {
	   			DISPLAYNAME, "setDoubleBuffered(boolean)",
	      		// SHORTDESCRIPTION, "TRUE to use off-screen painting buffer",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aFlag", new Object[] {
	   				DISPLAYNAME, "aFlag",
	      			// SHORTDESCRIPTION, "TRUE to buffer",
	      			})
	      		},
	      		new Class[] { 
	      			boolean.class
	      		}	    		
		  	),
		  	// setMaximumSize(Dimension)
		  	super.createMethodDescriptor(getBeanClass(),"setMaximumSize", 
				new Object[] {
	   			DISPLAYNAME, "setMaximumSize(Dimension)",
	      		// SHORTDESCRIPTION, "Set the maximum size of the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("maximumSize", new Object[] {
	   				DISPLAYNAME, "maximumSize",
	      			// SHORTDESCRIPTION, "Dimensions for maximum size",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Dimension.class
	      		}	    		
		  	),
		  	// setMinimumSize(Dimension)
		  	super.createMethodDescriptor(getBeanClass(),"setMinimumSize", 
				new Object[] {
	   			DISPLAYNAME, "setMinimumSize(Dimension)",
	      		// SHORTDESCRIPTION, "Set the minimum size of the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("minimumSize", new Object[] {
	   				DISPLAYNAME, "minimumSize",
	      			// SHORTDESCRIPTION, "Dimensions for minimum size",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Dimension.class
	      		}	    		
		  	),
		  	// setNextFocusableComponent(Component)
		  	super.createMethodDescriptor(getBeanClass(),"setNextFocusableComponent", 
				new Object[] {
	   			DISPLAYNAME, "setNextFocusableComponent(Component)",
	      		// SHORTDESCRIPTION, "Set the next component to get the focus",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aComponent", new Object[] {
	   				DISPLAYNAME, "aComponent",
	      			// SHORTDESCRIPTION, "Next component",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Component.class
	      		}	    		
		  	),
		  	// setPreferredSize(Dimension)
		  	super.createMethodDescriptor(getBeanClass(),"setPreferredSize", 
				new Object[] {
	   			DISPLAYNAME, "setPreferredSize(Dimension)",
	      		// SHORTDESCRIPTION, "Set the preferred size of the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("preferredSize", new Object[] {
	   				DISPLAYNAME, "preferredSize",
	      			// SHORTDESCRIPTION, "Dimensions for preferred size",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Dimension.class
	      		}	    		
		  	),
		  	// setOpaque(boolean)
		  	super.createMethodDescriptor(getBeanClass(),"setOpaque", 
				new Object[] {
	   			DISPLAYNAME, "setOpaque(boolean)",
	      		// SHORTDESCRIPTION, "TRUE if component is opaque",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("isOpaque", new Object[] {
	   				DISPLAYNAME, "isOpaque",
	      			// SHORTDESCRIPTION, "TRUE if opaque",
	      			})
	      		},
	      		new Class[] { 
	      			boolean.class
	      		}	    		
		  	),
		  	// setRequestFocusEnabled(boolean)
		  	super.createMethodDescriptor(getBeanClass(),"setRequestFocusEnabled", 
				new Object[] {
	   			DISPLAYNAME, "setRequestFocusEnabled(boolean)",
	      		// SHORTDESCRIPTION, "TRUE if the component can obtain focus on request",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aFlag", new Object[] {
	   				DISPLAYNAME, "aFlag",
	      			// SHORTDESCRIPTION, "TRUE to obtain focus",
	      			})
	      		},
	      		new Class[] { 
	      			boolean.class
	      		}	    		
		  	),
		  	// setToolTipText(String)
		  	super.createMethodDescriptor(getBeanClass(),"setToolTipText", 
				new Object[] {
	   			DISPLAYNAME, "setToolTipText(String)",
	      		// SHORTDESCRIPTION, "Set the tooltip text",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("text", new Object[] {
	   				DISPLAYNAME, "text",
	      			// SHORTDESCRIPTION, "Text to display",
	      			})
	      		},
	      		new Class[] { 
	      			String.class
	      		}	    		
		  	),
		  	// setVisible(boolean)
		  	super.createMethodDescriptor(getBeanClass(),"setVisible", 
				new Object[] {
	   			DISPLAYNAME, "setVisible(boolean)",
	      		// SHORTDESCRIPTION, "TRUE to make visible",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aFlag", new Object[] {
	   				DISPLAYNAME, "aFlag",
	      			// SHORTDESCRIPTION, "TRUE to make visible",
	      			})
	      		},
	      		new Class[] { 
	      			boolean.class
	      		}	    		
		  	),
		  	// unregisterKeyboardAction(KeyStroke)
		  	super.createMethodDescriptor(getBeanClass(),"unregisterKeyboardAction", 
				new Object[] {
	   			DISPLAYNAME, "unregisterKeyboardAction(KeyStroke)",
	      		// SHORTDESCRIPTION, "Unregister a keyboard action",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("aKeyStroke", new Object[] {
	   				DISPLAYNAME, "aKeyStroke",
	      			// SHORTDESCRIPTION, "TRUE to make visible",
	      			})
	      		},
	      		new Class[] { 
	      			javax.swing.KeyStroke.class
	      		}	    		
		  	),
		  	// update(Graphics)
		  	super.createMethodDescriptor(getBeanClass(),"update", 
				new Object[] {
	   			DISPLAYNAME, "update(Graphics)",
	      		// SHORTDESCRIPTION, "Update the component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("g", new Object[] {
	   				DISPLAYNAME, "graphics",
	      			// SHORTDESCRIPTION, "Graphics Context for painting",
	      			})
	      		},
	      		new Class[] { 
	      			java.awt.Graphics.class 
	      		}	    		
		  	),
		  	// updateUI()
			super.createMethodDescriptor(getBeanClass(),"updateUI", 
				new Object[] {
	   			DISPLAYNAME, "updateUI()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Reset the UI property",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	)	 	
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
/**
 * Return the property descriptors for this bean.
 * @return java.beans.PropertyDescriptor[]
 */
public java.beans.PropertyDescriptor[] getPropertyDescriptors() {
	try {
		PropertyDescriptor aDescriptorList[] = {
			// alignmentX
			super.createPropertyDescriptor(getBeanClass(),"alignmentX", new Object[] {
	      		// SHORTDESCRIPTION, "Preferred horizontal alignment",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// alignmentY
			super.createPropertyDescriptor(getBeanClass(),"alignmentY", new Object[] {
	      		// SHORTDESCRIPTION, "Preferred vertical alignment",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
			// autoscrolls
			super.createPropertyDescriptor(getBeanClass(),"autoscrolls", new Object[] {
	      		// SHORTDESCRIPTION, "Whether this component scrolls automatically when dragged",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
			// border
			super.createPropertyDescriptor(getBeanClass(),"border", new Object[] {
	      		// SHORTDESCRIPTION, "Component's border",
	      		BOUND, Boolean.TRUE,
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
			// debugGraphicsOptions
			super.createPropertyDescriptor(getBeanClass(),"debugGraphicsOptions", new Object[] {
	      		// SHORTDESCRIPTION, "Diagnostic options for graphics operations",
	      		EXPERT, Boolean.TRUE,
	      		DESIGNTIMEPROPERTY, Boolean.FALSE
	    		}
	    	),
			// doubleBuffered
			super.createPropertyDescriptor(getBeanClass(),"doubleBuffered", new Object[] {
	      		// SHORTDESCRIPTION, "Whether the painting is buffered",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// focusCycleRoot
			super.createPropertyDescriptor(getBeanClass(),"focusCycleRoot", new Object[] {
	      		// SHORTDESCRIPTION, "Component is the root of component tree with focus cycle",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// focusTraversable
			super.createPropertyDescriptor(getBeanClass(),"focusTraversable", new Object[] {
	      		SHORTDESCRIPTION, "TRUE if component can receive focus",
	    		}
	    	),
	    	// graphics
			super.createPropertyDescriptor(getBeanClass(),"graphics", new Object[] {
	      		// SHORTDESCRIPTION, "Component's graphic context",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// height
			super.createPropertyDescriptor(getBeanClass(),"height", new Object[] {
	      		// SHORTDESCRIPTION, "Height of component",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// insets
			super.createPropertyDescriptor(getBeanClass(),"insets", new Object[] {
	      		// SHORTDESCRIPTION, "Component border's insets",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// managingFocus
			super.createPropertyDescriptor(getBeanClass(),"managingFocus", new Object[] {
	      		// SHORTDESCRIPTION, "TRUE if the component manages focus",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// maximumSize
			super.createPropertyDescriptor(getBeanClass(),"maximumSize", new Object[] {
	      		// SHORTDESCRIPTION, "Maximum size of the component",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// minimumSize
			super.createPropertyDescriptor(getBeanClass(),"minimumSize", new Object[] {
	      		// SHORTDESCRIPTION, "Minimum size of the component",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// nextFocusableComponent
			super.createPropertyDescriptor(getBeanClass(),"nextFocusableComponent", new Object[] {
	      		// SHORTDESCRIPTION, "Next component to get the focus",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// opaque
			super.createPropertyDescriptor(getBeanClass(),"opaque", new Object[] {
	      		// SHORTDESCRIPTION, "TRUE if component is opaque",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// optimizedDrawingEnabled
			super.createPropertyDescriptor(getBeanClass(),"optimizedDrawingEnabled", new Object[] {
	      		// SHORTDESCRIPTION, "TRUE if component tiles its children",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// paintingTile
			super.createPropertyDescriptor(getBeanClass(),"paintingTile", new Object[] {
	      		// SHORTDESCRIPTION, "TRUE if component is currently painting a tile",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// preferredSize
			super.createPropertyDescriptor(getBeanClass(),"preferredSize", new Object[] {
	      		// SHORTDESCRIPTION, "Preferred size of the component",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// registeredKeyStrokes
			super.createPropertyDescriptor(getBeanClass(),"registeredKeyStrokes", new Object[] {
	      		// SHORTDESCRIPTION, "Component's registered keyboard actions",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// requestFocusEnabled
			super.createPropertyDescriptor(getBeanClass(),"requestFocusEnabled", new Object[] {
	      		// SHORTDESCRIPTION, "Whether component can obtain focus by calling requestFocus",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// rootPane
			super.createPropertyDescriptor(getBeanClass(),"rootPane", new Object[] {
	      		// SHORTDESCRIPTION, "Component's root pane",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// toolTipText
			super.createPropertyDescriptor(getBeanClass(),"toolTipText", new Object[] {
	      		// SHORTDESCRIPTION, "Text to display in tool tip",
	    		}
	    	),
	    	// topLevelAncestor
			super.createPropertyDescriptor(getBeanClass(),"topLevelAncestor", new Object[] {
	      		// SHORTDESCRIPTION, "Top-level window or applet",
	      		EXPERT, Boolean.TRUE,
	      		DESIGNTIMEPROPERTY, Boolean.FALSE
	    		}
	    	),
	    	// validateRoot
			super.createPropertyDescriptor(getBeanClass(),"validateRoot", new Object[] {
	      		// SHORTDESCRIPTION, "Whether to validate entire component tree on revalidate",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// visibleRect
			super.createPropertyDescriptor(getBeanClass(),"visibleRect", new Object[] {
	      		// SHORTDESCRIPTION, "Component's visible rectangle",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// width
			super.createPropertyDescriptor(getBeanClass(),"width", new Object[] {
	      		// SHORTDESCRIPTION, "Width of component",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// x
			super.createPropertyDescriptor(getBeanClass(),"x", new Object[] {
	      		// SHORTDESCRIPTION, "X-coordinate of the component's origin",
	      		EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// y
			super.createPropertyDescriptor(getBeanClass(),"y", new Object[] {
	      		// SHORTDESCRIPTION, "Y-coordinate of the component's origin",
	      		EXPERT, Boolean.TRUE
	    		}
	    	)	
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
/**
 * Gets the componentevent set descriptor.
 * @return java.beans.EventSetDescriptor
 */
public EventSetDescriptor propertyChangeEventSetDescriptor() {
	EventSetDescriptor aDescriptor = null;
	Class[] paramTypes = { java.beans.PropertyChangeEvent.class };
	MethodDescriptor aDescriptorList[] = {
			super.createMethodDescriptor(java.beans.PropertyChangeListener.class,
				"propertyChange", 
				new Object[] {
	   			DISPLAYNAME, "propertyChange",
	      		SHORTDESCRIPTION, "Event fired when a property has changed",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyChangeEvent", new Object[] {
	   				DISPLAYNAME, "propertyChangeEvent",
	      			// SHORTDESCRIPTION, "property changed event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	)
		};	
		aDescriptor = super.createEventSetDescriptor(getBeanClass(),
						"propertyChange", new Object[] {
						DISPLAYNAME, "propertyChangeEvents",
	      				SHORTDESCRIPTION, "All property change events",
	      			}, 
						aDescriptorList, java.beans.PropertyChangeListener.class,
						"addPropertyChangeListener", "removePropertyChangeListener");

	return aDescriptor;
}
/**
 * Gets the componentevent set descriptor.
 * @return java.beans.EventSetDescriptor
 */
public EventSetDescriptor vetoableChangeEventSetDescriptor() {
	EventSetDescriptor aDescriptor = null;
	Class[] paramTypes = { java.beans.PropertyChangeEvent.class };
	MethodDescriptor aDescriptorList[] = {
			super.createMethodDescriptor(java.beans.VetoableChangeListener.class,
				"vetoableChange", 
				new Object[] {
	   			DISPLAYNAME, "vetoableChange",
	      		SHORTDESCRIPTION, "Event fired when a constrained property has changed",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("propertyChangeEvent", new Object[] {
	   				DISPLAYNAME, "propertyChangeEvent",
	      			SHORTDESCRIPTION, "constrained property changed event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	)
		};	
		aDescriptor = super.createEventSetDescriptor(getBeanClass(),
						"vetoableChange", new Object[] {
						DISPLAYNAME, "vetoableChangeEvents",
	      				SHORTDESCRIPTION, "All constrained property change events",
	      			}, 
						aDescriptorList, java.beans.VetoableChangeListener.class,
						"addVetoableChangeListener", "removeVetoableChangeListener");

	return aDescriptor;
}
}
